<?php
/**
* @package   Warp Theme Framework
* @author    curvesncolors http://www.curvesncolors.com
* @copyright Copyright (C) curvesncolors GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');

// Create shortcut to parameters.
$params = $this->state->get('params');

?>

<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task == 'weblink.cancel' || document.formvalidator.isValid(document.id('adminForm'))) {
			<?php echo $this->form->getField('description')->save(); ?>
			Joomla.submitform(task);
		}
		else {
			alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
		}
	}
</script>

<div id="system">
	
	<?php if ($this->params->get('show_page_heading', 1)) : ?>
	<h1 class="title"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
	<?php endif; ?>
	
	<form class="submission box style" action="<?php echo JRoute::_('index.php?option=com_weblinks&view=form&w_id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm">
		<fieldset>
			<legend><?php echo JText::_('COM_WEBLINKS_LINK'); ?></legend>
	
			<div>
				<?php echo $this->form->getLabel('title'); ?>
				<?php echo $this->form->getInput('title'); ?>
			</div>

			<div>
				<?php echo $this->form->getLabel('alias'); ?>
				<?php echo $this->form->getInput('alias'); ?>
			</div>

			<div>
				<?php echo $this->form->getLabel('catid'); ?>
				<?php echo $this->form->getInput('catid'); ?>
			</div>
			
			<div>
				<?php echo $this->form->getLabel('url'); ?>
				<?php echo $this->form->getInput('url'); ?>
			</div>
			
			<?php if ($this->user->authorise('core.edit.state', 'com_weblinks.weblink')): ?>
			<div>
				<?php echo $this->form->getLabel('state'); ?>
				<?php echo $this->form->getInput('state'); ?>
			</div>
			<?php endif; ?>
			
			<div>
				<?php echo $this->form->getLabel('language'); ?>
				<?php echo $this->form->getInput('language'); ?>
			</div>
				
			<div>
				<?php echo $this->form->getLabel('description'); ?>
				<?php echo $this->form->getInput('description'); ?>
			</div>
				
		</fieldset>
		
		<div>
			<button type="button" onclick="Joomla.submitbutton('weblink.save')"><?php echo JText::_('JSAVE') ?></button>
			<button type="button" onclick="Joomla.submitbutton('weblink.cancel')"><?php echo JText::_('JCANCEL') ?></button>
		</div>

		<input type="hidden" name="return" value="<?php echo $this->return_page;?>" />
		<input type="hidden" name="task" value="" />
		<?php echo JHtml::_( 'form.token' ); ?>
	</form>
		
</div>